this.name        = "ups_slaves"; 
this.author      = "eric walch"; 
this.copyright   = " 2008 the Oolite team."; 
this.description = "Slaves missions of UPS Courier"; 
this.version     = "1.3.3"; 


this.startUp = function()
{
    if (oolite.compareVersion("1.70") > 0)
    {
        // Oolite version is older than 1.70.
        LogWithClass("script."+this.name, "This UPS-Courier missions does not run under Oolite version " + oolite.versionString + " Slave missions are disabled.")
        delete this.missionScreenEnded
        delete this.shipExitedWitchspace
        delete this.shipDockedWithStation
        delete this.shipLaunchedFromStation
    }
    this.timer= new Timer(this, this.ups_timed_missionoffers, 1, 1)
    this.timer.stop()
}

/* this.tickle is activated at the same points as the legacy script is activated. So it could be on every status. (even EXITTING_WITCHSPACE) Currently this is a good way to set up conclictfree messages that wait on each other. When you do it on docking and you detect there is already an other message shown, you won't get an second change for displaying the message.
Note that besides the tickles that are fired every 10 seconds, there is one just after docking, were status == "STATUS_DOCKED" but guiScreen = "GUI_SCREEN_MAIN". During the further docked tickles, guiScreen depends on the screen you are looking at.
*/

this.shipDockedWithStation = function()
{
// missionVariables.ups_slaverescue is set to "YES" by a scripted pilot.
    if (missionVariables.ups_slaverescue == "YES")
    {
        this.ups_missionoffers()
    }
}

/*
All the screen offers look alike. Therefor I created a function that does the work. With a single call from other parts all the things are set. Currently I do not use music or ships. But when needed you can add them to the parameterlist and in mission.showShipModel();mission.setMusic(). When it has a value it is set and when null it is cleared, like I now do with mission.setBackgroundImage(backGround).
*/
this.missionScreen=function(messageKey, backGround, choiceKey)
{
        mission.showShipModel();mission.setMusic()
	mission.setBackgroundImage(backGround);
	mission.showMissionScreen();
	mission.addMessageTextKey(messageKey);
        if (choiceKey) mission.setChoicesKey(choiceKey)
	mission.setBackgroundImage();
}

/*
Missionoffers are trigered by docking and by ending of a missionscreen. However there are situations were the display of a missionscreen has be skipped when an other script has asked for it by setting "missionVariables.offering". But when that script does not do a display, there will never come a trigger. That is why the timer is started whenever display of the missionscreen is skipped. (The timer is off by default). The timer calls the function below that stays active untill the offering variable is free again. Launching will also reset the offering variable therefor the timer will only run when docked.
Instead if a timer one also could use the tickle event to periodically check the offers but that checks only every 10 seconds.
*/
this.ups_timed_missionoffers = function()
{
    if (missionVariables.offering || (mission.choice && mission.choice != "")) return
    this.timer.stop()
    if (player.docked) this.ups_missionoffers()
}
/*
All the offers are generated with the function below. The function is called after docking, after ending a previous mission screen when the choices are sorted out and by the timer.
*/
this.ups_missionoffers = function()
{
    if (guiScreen == "GUI_SCREEN_MISSION") return; // there will be a "missionScreenEnded" in future to react uppon.
    if (missionVariables.offering || (mission.choice && mission.choice != "")) {this.timer.start(); return}
    // there might not be a "missionScreenEnded" in future to react uppon, so set up an timer.
    if (player.dockedStation.isMainStation)
    {
        if (missionVariables.ups_slaves == "SLAVE" && !mission.choice)
        {
                this.missionScreen("ups_slave_homeland", "UPS.png", "ups_slave_accepted_yesno")
                missionVariables.offering ="HOMELANDS"
        }
        if (missionVariables.ups_slplanet == system.ID && missionVariables.ups_slaves == "HOMELAND")
        {
                missionVariables.ups_slaves = "NOT_NOW"
//              mission.unmarkSystem(missionVariables.ups_slplanet) // this command crashes Oolite 1.70!
                player.call("removeMissionDestination:", missionVariables.ups_slplanet)
                this.missionScreen("ups_slave_homeland2", "UPS.png")
                mission.setInstructionsKey() 
                player.awardCargo("Gem-Stones", 15) 
                missionVariables.ups_slcount++
                player.call("increasePassengerReputation")
        }
        if(missionVariables.ups_slaves == "RESCUEOFFER" && system.government > 3 && system.economy < 3)
        {
                this.missionScreen("ups_slave_rescueoffer", "UPS.png", "ups_slave_accepted2_yesno")
                missionVariables.offering ="RESCUE"
        }
        if(missionVariables.ups_slaves == "RESCUE" && system.ID == missionVariables.ups_sl2planet && missionVariables.ups_convoy == "KILLED")
        {
                if(missionVariables.ups_sl2count > 10)
                {
                    this.missionScreen("ups_slave_rescue10")
                    player.awardCargo("Gem-Stones", 50)
                } 
                else
                {
                    if(missionVariables.ups_sl2count > 0) this.missionScreen("ups_slave_rescue")
                    else this.missionScreen("ups_slave_rescue0")
                }
                missionVariables.ups_sl2count = null 
//              mission.unmarkSystem(missionVariables.ups_sl2planet) // this command crashes Oolite 1.70!
                player.call("removeMissionDestination:", missionVariables.ups_sl2planet)
                missionVariables.ups_sl2planet = null
                missionVariables.ups_sl2planetname = null
                missionVariables.ups_convoy = null
                missionVariables.ups_convoy_attack = null
                mission.setInstructionsKey()
                missionVariables.ups_slaves = "NOT_NOW"
        }
        if (missionVariables.ups_slaves == "FINALOFFER" && system.government > 2 && !mission.choice)
        {
                this.missionScreen("ups_slave_final", null, "ups_slave_accepted_yesno")
                missionVariables.offering ="FINAL"
        }
        if (missionVariables.ups_slaves == "FINAL" && missionVariables.ups_slplanet == system.ID)
        {
            this.missionScreen("ups_slave_groundbattle")
            missionVariables.ups_slaves = "GROUNDBATTLE"
            mission.setInstructionsKey("ups_slave_groundbattle_small") 
            missionVariables.ups_slavesrescued = 5
        }
        if (missionVariables.ups_slaves == "DEBRIEFING" && missionVariables.ups_slplanet == system.ID)
        {
            missionVariables.ups_slaves = "NOT_NOW"
            mission.setInstructionsKey() 
            if(missionVariables.ups_slavesrescued == "5")
            {
                this.missionScreen("ups_slave_debriefing")
                player.credits += 6000
            }
            else
            {
                if(missionVariables.ups_slavesrescued == "0")
                {
                    this.missionScreen("ups_slave_debriefing2")
                }
                else
                {
                    this.missionScreen("ups_slave_debriefing1")
                    player.credits += 4000
                }
            }
            mission.setInstructionsKey() 
            missionVariables.ups_slavereset = "YES"
//          mission.unmarkSystem(missionVariables.ups_slplanet) // this command crashes Oolite 1.70!
            player.call("removeMissionDestination:", missionVariables.ups_slplanet)
        }
    }
    if (player.dockedStation.shipDescription == "Ground Radar")
    {
        if (missionVariables.ups_slaves == "DEBRIEFING" || missionVariables.ups_slaves == "GROUNDBATTLE")
        {
            this.missionScreen("ups_slave_trapped")
            missionVariables.ups_slaves = "FAILED", 
            missionVariables.ups_slavesreset = "YES"
        }
    }
}

this.missionScreenEnded = function()
{
    if(!player.docked) return;
    if (missionVariables.ups_slaverescue == "YES") 
    {
        if (missionVariables.offering == "HOMELANDS")
        {
            if (mission.choice == "YESSlave")
            {
                mission.markSystem(missionVariables.ups_slplanet) 
                mission.resetMissionChoice()
                mission.setInstructionsKey("ups_slave_small") 
                missionVariables.ups_slaves = "HOMELAND" 
                missionVariables.offering = null
            }
            else
            {
                if (mission.choice == "NOSlave")
                { 
                    mission.resetMissionChoice()
                    missionVariables.ups_slaves = "NOT_NOW" 
                    missionVariables.offering = null
                } else {this.missionScreen("ups_warning2", "UPS.png"); missionVariables.offering = null}
            }
        }
        if (missionVariables.offering == "RESCUE")
        {
            if (mission.choice == "YESSlave")
            {
                mission.markSystem(missionVariables.ups_sl2planet) 
                mission.resetMissionChoice()
                mission.setInstructionsKey("ups_slave_small3") 
                missionVariables.ups_slaves = "RESCUE" 
                missionVariables.offering = null
                missionVariables.ups_sl2count = "0"
                missionVariables.ups_convoy = null 
                missionVariables.ups_convoy_attack = null
            }
            else
            {
                if (mission.choice == "NOSlave")
                { 
                    mission.resetMissionChoice()
                    missionVariables.ups_slaves = "NOT_NOW" 
                    missionVariables.offering = null
                } else {this.missionScreen("ups_warning2", "UPS.png"); missionVariables.offering = null}
            }
        }
        if (missionVariables.offering == "FINAL")
        {
            if (mission.choice == "YESSlave")
            {
                mission.markSystem(missionVariables.ups_slplanet) 
                mission.resetMissionChoice()
                mission.setInstructionsKey("ups_slave_small2") 
                missionVariables.ups_slaves = "FINAL" 
                missionVariables.offering = null
            }
            else
            {
                if (mission.choice == "NOSlave")
                { 
                    mission.resetMissionChoice()
                    missionVariables.ups_slaves = "NOT_NOW" 
                    missionVariables.offering = null
                } else {this.missionScreen("ups_warning2", "UPS.png"); missionVariables.offering = null}
            }
        }
        this.ups_missionoffers()
    }
}

/* Defining a function with: "function = setUpShips_ups_slaves()" will lead to a function that is globally within Oolite. Meaning it is also seen by other scripts and therefor should have unique names.  Function defined  by "this.setUpShips_ups_slaves = function()" are only local to the script and will not give name conflicts with other OXP's. Therefor the method below is preferable.*/
this.setUpShips_ups_slaves = function()
{
    if(missionVariables.ups_slaves == "GROUNDBATTLE")
    {
        if(system.ID == missionVariables.ups_slplanet && system.countShipsWithRole("ups_slave_satellite") == 0)
        {
            system.legacy_addShipsAtPrecisely("ups_slave_satellite", 1, "pwp", 0, 0, 1.01) 
            system.legacy_addShipsAtPrecisely("ups_slave_satellite", 1, "pwp", 0, 0.05, 1.01) 
            system.legacy_addShipsAtPrecisely("ups_slave_satellite", 1, "pwp", 0.05, 0, 1.01) 
            system.legacy_addShipsAtPrecisely("ups_slave_satellite", 1, "pwp", 0.05, 0.05, 1.01) 
            missionVariables.ups_satellitecount = "4"
        }
    }
    if(missionVariables.ups_slaves == "RESCUE")
    {
        if(system.ID == missionVariables.ups_sl2planet && system.countShipsWithRole("ups-convoy-l") == 0 && !missionVariables.ups_convoy && !missionVariables.ups_convoy_attack)
        {
            system.legacy_addSystemShips("ups-convoy-l", 1, 0.5) 
        }
    }
}

this.shipExitedWitchspace = function()
{
  if (missionVariables.ups_slaverescue == "YES")
  {
    this.setUpShips_ups_slaves()
    if (!missionVariables.ups_slaves)
    { // selection of a tyarget system for all slave missions. And make sure you don't select a Nova system.
        if(system.government == 2 && system.economy > 5 && !system.goneNova)
        {
            missionVariables.ups_slaves = "NO" 
            missionVariables.ups_slplanet = system.ID 
            missionVariables.ups_slplanetname = ExpandDescription("[%H]") 
            missionVariables.ups_slcount = "0"
        }
    }
    if (missionVariables.ups_slaves == "NOT_NOW" && Math.random() < 0.1){missionVariables.ups_slaves = "NO"}
    if(missionVariables.ups_slaves == "NO")
    {
        if (missionVariables.ups_slaves == "NO" && missionVariables.ups_slcount > 2 && Math.random() > 0.9 && system.government > 2)
        {
            missionVariables.ups_slaves = "FINALOFFER"
        }
        if (missionVariables.ups_slaves == "NO" && system.ID > -1 && Math.random() > 0.75 && system.economy < 3)
        {
            let position = Math.random()*0.8+0.1; system.legacy_addSystemShips("ups-slavecobra", 1, position) 
        }
        if (missionVariables.ups_slaves == "NO" && missionVariables.ups_slcount > 1 && Math.random() > 0.9 && system.government == 2 && !system.goneNova)
        {
            missionVariables.ups_slaves = "RESCUEOFFER"
            missionVariables.ups_sl2planet = system.ID
            missionVariables.ups_sl2planetname = ExpandDescription("[%H]") 
        }
    }
    if (missionVariables.ups_slavesreset == "YES")
    {
//      mission.unmarkSystem(missionVariables.ups_slplanet) // this command crashes Oolite 1.70!
        player.call("removeMissionDestination:", missionVariables.ups_slplanet)
        mission.setInstructionsKey() 
        if (missionVariables.ups_sl2count)
        {player.call("removeMissionDestination:", missionVariables.ups_sl2planet)}
        missionVariables.ups_slavesreset = null 
        missionVariables.ups_slcount = null
        missionVariables.ups_slavesrescue = null
        missionVariables.ups_slaves = null
        missionVariables.ups_slavename = null
        missionVariables.ups_slplanet = null
        missionVariables.ups_slplanetname = null
        missionVariables.ups_slavesrescued = null
        missionVariables.ups_sl2planet = null
        missionVariables.ups_sl2planetname = null
    }
  }
}

this.shipLaunchedFromStation = function()
{
  if (missionVariables.ups_slaverescue == "YES")
  {
    this.setUpShips_ups_slaves()
  }
}